using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.School
{                                        
    public partial class FNewSchool : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.ZB.N1200.ELearning.BL.BO.School _newSchool = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        public FNewSchool()
        {
            InitializeComponent();
        }

        public PI.ZB.N1200.ELearning.BL.BO.School NewSchool
        {
            get 
            {
                if (_newSchool == null)
                {
                    if ((!String.IsNullOrEmpty(_gTextBoxName.Text)) && (!String.IsNullOrEmpty(_gTextBoxTown.Text)))
                    {
                        _newSchool = BLZSBELearning.School.New();
                        _newSchool.Name = _gTextBoxName.Text.Trim();
                        _newSchool.Town = _gTextBoxName.Text.Trim();

                        BLZSBELearning.School.Save(_newSchool);
                    }
                }

                return _newSchool; 
            }
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            bool _isValid = true;
            List<string> _listMessage = new List<string>();

            _gTextBoxName.ErrorText = null;

            if (String.IsNullOrEmpty(_gTextBoxName.Text))
            {
                _gTextBoxName.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText));
                _isValid = false;
            }

            if (String.IsNullOrEmpty(_gTextBoxTown.Text))
            {
                _gTextBoxTown.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelTown.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelTown.PlainText));
                _isValid = false;
            }

            if (_isValid)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                PI.FM.N000.Base.WinForms.Controls.FDefaultMessage _dialog = new PI.FM.N000.Base.WinForms.Controls.FDefaultMessage();
                _dialog.SetMessage = _listMessage;
                _dialog.ShowDialog();
            }
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}